/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Command;
import emulator.hardware.nmos6502.CommandSet;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.Operand;
import emulator.hardware.nmos6502.operands.Absolute;
import emulator.hardware.nmos6502.operands.AbsoluteX;
import emulator.hardware.nmos6502.operands.AbsoluteY;
import emulator.hardware.nmos6502.operands.Immediate;
import emulator.hardware.nmos6502.operands.IndirectX;
import emulator.hardware.nmos6502.operands.IndirectY;
import emulator.hardware.nmos6502.operands.ZeroPage;
import emulator.hardware.nmos6502.operands.ZeroPageX;

public class LDA
implements Command {
    @Override
    public void execute(Cpu6502 cpu, Operand operand) throws EmulatorException {
        HwByte value = operand.getByte();
        Flags6502 flags = cpu.getFlags();
        flags.setNZFromValue(value);
        cpu.setAccu(value);
        cpu.setFlags(flags);
    }

    @Override
    public String getName() {
        return "LDA";
    }

    @Override
    public void register(CommandSet cset) {
        cset.defineCommand(169, this, new Immediate());
        cset.defineCommand(165, this, new ZeroPage());
        cset.defineCommand(181, this, new ZeroPageX());
        cset.defineCommand(173, this, new Absolute());
        cset.defineCommand(189, this, new AbsoluteX());
        cset.defineCommand(185, this, new AbsoluteY());
        cset.defineCommand(161, this, new IndirectX());
        cset.defineCommand(177, this, new IndirectY());
    }
}

